package gov.va.med.mhv.usermgmt.integration.service.ejb;

import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.integration.registry.transfer.Facility;
import gov.va.med.mhv.integration.registry.transfer.Patient;
import gov.va.med.mhv.integration.registry.transfer.PersonalInfo;
import gov.va.med.mhv.integration.registry.transfer.Status;
import gov.va.med.mhv.usermgmt.integration.service.IntegrationServiceFactory;
import gov.va.med.mhv.usermgmt.integration.service.PatientIdentityService;

/**
 * Service session bean for the Patient Identity Service
 *
 */
public class PatientIdentityServiceBean implements SessionBean {
    //  Note that the EJB specification is external to this project.
    // because this EJB defines the interface between the integration 
    // and the business tier.
    // Therefore, this EJB is not generated by Atlas

	/**
     * 
     */
    private static final long serialVersionUID = -7204973824202458216L;
    
    protected SessionContext sessionContext = null;

	/**
	 * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
	 */
	public void setSessionContext(SessionContext ctx) throws EJBException {
		sessionContext = ctx;			
	}

    /* (non-Javadoc)
     * @see gov.va.med.mhv.integration.registry.services.ejb.
     * PatientIdentityServiceRemote#getPatientForICN(java.lang.String)
     */
    public Patient getPatientForICN(String icn) throws RemoteException {
        Precondition.assertNotBlank("icn", icn);
        return getService().getPatientForICN(icn);
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.integration.registry.services.ejb.
     * PatientIdentityServiceRemote#finalizeCorrelation(
     * gov.va.med.mhv.integration.registry.transfer.Patient, 
     * gov.va.med.mhv.integration.registry.transfer.Status)
     */
    public Status finalizeCorrelation(Patient patient, Status status) 
        throws RemoteException 
    {
        Precondition.assertNotNull("patient", patient);
        return getService().finalizeCorrelation(patient, status);
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.integration.registry.services.ejb.
     * PatientIdentityServiceRemote#finalizeUncorrelation(
     * gov.va.med.mhv.integration.registry.transfer.Patient, 
     * gov.va.med.mhv.integration.registry.transfer.Status)
     */
    public Status finalizeUncorrelation(Patient patient, Status status) 
        throws RemoteException 
    {
        Precondition.assertNotNull("patient", patient);
        return getService().finalizeUncorrelation(patient, status);
    }




    /* (non-Javadoc)
     * @see gov.va.med.mhv.integration.registry.services.ejb.
     * PatientIdentityServiceRemote#updateFacilities(
     * gov.va.med.mhv.integration.registry.transfer.Patient, 
     * java.util.ArrayList)
     */
    public Status updateFacilities(Patient patient, 
        ArrayList<Facility> facilities) throws RemoteException 
    {
        Precondition.assertNotNull("patient", patient);
        Precondition.assertNotNull("facilities", facilities);
        return getService().updateFacilities(patient, facilities);
    }




    /* (non-Javadoc)
     * @see gov.va.med.mhv.integration.registry.services.ejb.
     * PatientIdentityServiceRemote#updatePersonalInfo(
     * gov.va.med.mhv.integration.registry.transfer.Patient, 
     * gov.va.med.mhv.integration.registry.transfer.PersonalInfo)
     */
    public Status updatePersonalInfo(Patient patient, 
        PersonalInfo personalInfo) throws RemoteException 
    {
        Precondition.assertNotNull("patient", patient);
        Precondition.assertNotNull("personalInfo", personalInfo);
        return getService().updatePersonalInfo(patient, personalInfo);
    }




    /* (non-Javadoc)
     * @see gov.va.med.mhv.integration.registry.services.ejb.
     * PatientIdentityServiceRemote#changeIcn(
     * gov.va.med.mhv.integration.registry.transfer.Patient, java.lang.String)
     */
    public Status changeIcn(Patient patient, String icn) 
        throws RemoteException 
    {
        Precondition.assertNotNull("patient", patient);
        Precondition.assertNotEmpty("icn", icn);
        return getService().changeIcn(patient, icn);
    }




    /* (non-Javadoc)
     * @see gov.va.med.mhv.integration.registry.services.ejb.
     * PatientIdentityServiceRemote#removeCorrelation(
     * gov.va.med.mhv.integration.registry.transfer.Patient)
     */
    public Status removeCorrelation(Patient patient) 
        throws RemoteException 
    {
        Precondition.assertNotNull("patient", patient);
        return getService().removeCorrelation(patient);
    }




    /* (non-Javadoc)
     * @see gov.va.med.mhv.integration.registry.services.ejb.
     * PatientIdentityServiceRemote#mergePatients(
     * gov.va.med.mhv.integration.registry.transfer.Patient, 
     * gov.va.med.mhv.integration.registry.transfer.Patient, java.lang.String)
     */
    public Status mergePatients(Patient fromPatient, Patient toPatient, 
        String referenceId) throws RemoteException
    {
        Precondition.assertNotNull("toPatient", toPatient);
        Precondition.assertNotNull("fromPatient", fromPatient);
        Precondition.assertNotBlank("referenceId", referenceId);
        return getService().mergePatients(fromPatient, toPatient, 
            referenceId);
    }


    


    public void ejbCreate() throws CreateException {
    }

    /**
     * @see javax.ejb.SessionBean#ejbActivate()
     */
    public void ejbActivate() throws EJBException {
    }


    /**
     * @see javax.ejb.SessionBean#ejbPassivate()
     */
    public void ejbPassivate() throws EJBException {
    }


    /**
     * @see javax.ejb.SessionBean#ejbRemove()
     */
    public void ejbRemove() throws EJBException {       
    }

    /**
     * Get a service instance
     */ 
    private PatientIdentityService getService() {
        return IntegrationServiceFactory.createPatientIdentityService();
    }   

    

}
